<?php

/**
 * @file
 * Manage mcms notifications
 */

/**
 * callback for url admin/mcms_ua that lists all the notifications.
 */
function mcms_ua_notifications_view(){

  //affichage du formulaire
  return drupal_get_form('mcms_ua_notifications_view_form');
}

/**
 * Render a table containing the last 50 notifications
 * @global type $base_url
 * @return string
 */
function mcms_ua_notifications_view_form() {

  // Variables
  global $base_url;
  $form = array();

  // Titre
  $form['formHeader'] = array(
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer">
                    <div class="formHeader" style="margin-left: 0px;">
                      <h2>'.t('Last 50 push notifications').'</h2>
                    </div>',
  );

  // Table : thead
  $form['tableHeader'] = array(
    '#type' => 'markup',
    '#prefix' => '<table class="tableheader-processed" id="lastNotifications">
                    <thead>
                      <tr>
                        <th>'. t('Message').'</th>
                        <th>'. t('Associated node title').'</th>
                        <th>'. t('Created').'</th>
                        <th>'. t('Sent').'</th>
                        <th>'. t('Error message').'</th>
                      </tr>
                    </thead>
                    <tbody>',
  );

  // Récupération des dernières notifications
  $notifications = mcms_ua_get_last_notifications(50);

  // Affichage des notifications récupérées
  $i = 0;
  foreach ($notifications as $notification) {
    $rowStyle = $i % 2 ==0 ? "odd" : "even";
    $form['row-start-'.$notification->id] = array(
    '#type' => 'markup',
    '#prefix' => '<tr class="'.$rowStyle.'">
                    <td>'.$notification->message.'</td>
                    <td>'.$notification->nodetitle.'</td>
                    <td>'. format_date($notification->created, 'short').'</td>
                    <td>',
    );

    $form['row-status-'.$notification->id.'-sent'] = array(
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => 0,
    );
    if($notification->status == 1)
      $form['row-status-'.$notification->id.'-sent']['#attributes'] = array('checked' => 'checked');

    $form['row-end-'.$notification->id] = array(
    '#type' => 'markup',
    '#prefix' => '</td>
                  <td>'.$notification->errormessage.'</td>
                 </tr>',
    );
    $i++;
  }

  // Table : fermeture
  $form['tableFooter'] = array(
    '#type' => 'markup',
    '#prefix' => '</tbody>
                </table>',
  );


  // Fermeture générale
  $form['formFooter'] = array(
    '#type' => 'markup',
    '#prefix' => '</div>',
  );

  // Retourne le HTML
  return $form;
}


/**
 * callback for url admin/mcms_ua/create that display a form in order to create notifications
 */
function mcms_ua_notifications_create(){

  //affichage du formulaire
  return drupal_get_form('mcms_ua_notifications_create_form');
}


/**
 * Render a form that allow user to create a new push notification
 * @return array
 */
function mcms_ua_notifications_create_form(){
  $form = array();

  // Message de la notification
  $form['message'] = array(
    '#type' => 'textfield',
    '#title' => t('Message'),
    '#size' => 120,
    '#maxlength' => 255,
    '#required' => TRUE,
  );

  // // Système de recherche par auto-completion
  // $form['searchNode'] = array(
  //   '#type' => 'markup',
  //   '#prefix' => '<div class="editor-label"><label>'. t("Related node") .'</label>
  //                 </div>
  //                 <div class="editor-field">
  //                   <input id="inputSearch" name="inputSearch" type="text" class="form-text form-autocomplete" data-provide="typeahead" />
  //                   <input id="nid" type="hidden" name="nid"/>
  //                 </div>
  //                 <div style="margin-top:15px;">',
  //   );

  // Bouton de validation
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );

  // // Fermeture des divs restantes
  // $form['formFooter'] = array(
  //   '#type' => 'markup',
  //   '#prefix' => '</div></div>',
  // );

  // // Ajout de CSS
  // $form['#attached']['css'] = array(
  //   drupal_get_path('module', 'mcms_ua') . '/css/themes/base/jquery.ui.core.css',
  //   drupal_get_path('module', 'mcms_ua') . '/css/themes/base/jquery.ui.theme.css',
  //   drupal_get_path('module', 'mcms_ua') . '/css/themes/base/jquery.ui.selectable.css',
  //   drupal_get_path('module', 'mcms_ua') . '/css/themes/base/jquery.ui.autocomplete.css',
  // );

  // // Ajout de JS
  // $form['#attached']['js'] = array(
  //   drupal_get_path('module','mcms_ua') . '/js/jquery-1.9.1.min.js',
  //   drupal_get_path('module','mcms_ua') . '/js/jquery-ui-1.10.1.js',
  //   drupal_get_path('module', 'mcms_ua') . '/js/form_init.js',
  // );

  //retourne le tableau formulaire
  return $form;
}

/**
 * Implements hook_form_validate
 */
function mcms_ua_notifications_create_form_validate($form, &$form_state){

  // // Liste des champs à vérifier
  // $mandatoryFields = array('message');

  // // On vérifie que les champs évoqués ont bien été renseignés (message)
  // foreach ($mandatoryFields as $field) {
  //   $fieldValue = $form[$field]["#value"];

  //   // Vérifier que la valeur du champ est != ""
  //   if(!isset($fieldValue) || $fieldValue == "")
  //     form_set_error ($field, t('The field '. $form[$field]["#title"] .' is mandatory'));
  // }
}

/**
 * Implements hook_form_sumbit
 */
function mcms_ua_notifications_create_form_submit($form, &$form_state){

  // Node lié à la notification
  // TODO : pour le moment les notifications ne sont jamais liées à un node.
  $nid = null;

  //dpm(isset($_POST['inputSearch']));
  //dpm($_POST['inputSearch'] != '')
  // if((isset($_POST['inputSearch']) || $_POST['inputSearch'] != '') && isset($_POST['nid'])){
  //   $nid = $_POST['nid'];
  // }
  //dpm($nid);

  // Création d'une nouvelle notification
  $notificationId = db_insert('mcms_ua_notifications')
    ->fields(array(
      'nid' => $nid,
      'message' => $form['message']["#value"],
      'status' => 0,  // la notificationation n'a pas encore été envoyée => status = 0
      'created' => time()
      ))
    ->execute();

  // Tentative d'envoie de la notification push
  $pushResult = mcms_ua_push($form['message']["#value"], $nid);

  // Mise à jours de ses informations en BDD (que ce soit un succès ou un échec)
  db_update('mcms_ua_notifications')
    ->fields(array(
      'status' => $pushResult->status,
      'json' => $pushResult->json,
      'errormessage' => $pushResult->errorMessage
    ))
    ->condition('id', $notificationId, '=')
    ->execute();

  // Si l'envoie a réussi
  if($pushResult->status == 1) {
    drupal_set_message(t('The notification has been sent'));
  // Si l'envoie a échoué
  } else {
    drupal_set_message(t('An error occured while sending the notification'),'error');
  }

  // Redirect après submit
  $form_state['redirect'] = 'admin/mcms_ua';
}

/**
 * Callback for push notification tab on a node
 */
function mcms_ua_node_push(){

  //affichage du formulaire
  return drupal_get_form('mcms_ua_node_push_form');
}

/**
 * Display the form to allow a user to send a push notification with the context node item attached
 */
function mcms_ua_node_push_form(){
  $node = node_load(arg(1));
  $form = array();

  // Titre de la page
  $form['form_title'] = array(
    '#type' => 'markup',
    '#prefix' => '<div class="formTitle"><h2>
                    ' . t('Send a new notification with the item "') . $node->title . t('" attached.') .
                  '</h2></div>',
  );

  // Saisie du message
  $form['message'] = array(
    '#type' => 'textfield',
    '#title' => t('Message'),
    '#size' => 120,
    '#maxlength' => 255,
    '#required' => TRUE,
  );

  // Bouton submit
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );

  return $form;
}

/**
 * Validate the form
 * @param type $form
 * @param type $form_state
 */
function mcms_ua_node_push_form_validate($form, $form_state) {

}

function mcms_ua_node_push_form_submit($form, &$form_state) {

  // Récupération de l'id du node lié
  $nid = arg(1);

  // Création d'une nouvelle notification
  $notificationId = db_insert('mcms_ua_notifications')
    ->fields(array(
        'nid' => $nid,
        'message' => $form['message']["#value"],
        'status' => 0, // la notificationation n'a pas encore été envoyée => status = 0
        'created' => time()
      ))
    ->execute();

  // Tentative d'envoie de la notification push
  // TODO : ajout nid ?
  $pushResult = mcms_ua_push($form['message']["#value"]);

  // Mise à jours de ses informations en BDD (que ce soit un succès ou un échec)
  db_update('mcms_ua_notifications')
    ->fields(array(
      'status' => $pushResult->status,
      'json' => $pushResult->json,
      'errormessage' => $pushResult->errorMessage
      )
    )
    ->condition('id', $notificationId, '=')
    ->execute();

  // Si l'envoie a réussi
  if($pushResult->status == 1) {
    drupal_set_message(t('The notification has been sent'));
  // Si l'envoie a échoué
  } else {
    drupal_set_message(t('An error occured while sending the notification'),'error');
  }

  // Redirect après submit
  $form_state['redirect'] = 'admin/mcms_ua';
}


/**
 * Search authorized nodes by title
 * @param type $string
 */
function mcms_ua_node_search_auto_complete($string){
  $cts = mcms_ua_get_all_compatible_content_types();
  if(!$cts){
    drupal_json_output(array());
  }
  $results = db_query('SELECT nid, title FROM node WHERE type IN(:cts) AND title LIKE \'%'.$string.'%\' ORDER BY title', array(':cts' => $cts))
                      ->fetchAll();
  $returnResults = array();
  foreach ($results as $node) {
    $res = new stdClass();
    $res->nid = $node->nid;
    $res->title = $node->title . ' (' . $node->nid . ')';
    array_push($returnResults, $res);
  }
  drupal_json_output($returnResults);
}
