var map, editor, markers;
var markerstab = [];
var geoJSON;
var geoJsonFieldId;
var encodedPolylineConverter;
var projWGS84 = new OpenLayers.Projection("EPSG:4326");
var allowOnlyOne = false;
var testval;
var allowTracks = false;
var allowPoints = false;
var lonFieldId;
var latFieldId;
var encodedPolylineConverter_options;

function initMap(lon, lat, zoom, _featureType) {

    //limit zone      
    var maxExtent = null;
    if(typeof mcms_mapMaxExtent !== 'undefined' && mcms_mapMaxExtent.length > 0)
    {
        maxExtent = new OpenLayers.Bounds(mcms_mapMaxExtent[0], mcms_mapMaxExtent[1], mcms_mapMaxExtent[2], mcms_mapMaxExtent[3]);
    }
    
    // Create an OpenLayers map
    map = new OpenLayers.Map('map', {
        projection: "EPSG:900913",
        controls: [],
        restrictedExtend : maxExtent
    });

    //test XYZ
    var mapOptions = {
        url : mcms_mapProviderUrls,
        serverResolutions: mcms_mapServerResolutions,
        resolutions: mcms_mapResolutions,
        zoomOffset: 12,
        projection: "EPSG:900913",
        numZoomLevel: 6,
        minZoomLevel: 12,
        isBaseLayer: true,
    }
    var newLayer;

    if(mcms_mapProvider == 'xyz'){
        newLayer = new OpenLayers.Layer.XYZ('xyzMap', mapOptions.url, mapOptions);
    } else if (mcms_mapProvider == 'google') {
        newLayer = new OpenLayers.Layer.Google('map', mapOptions);
    } else if(mcms_mapProvider == 'osm'){
        newLayer = new OpenLayers.Layer.OSM('osmMap', mapOptions.url, mapOptions)
    } else{
        alert('unknown map type ' + mcms_mapProvider);
    }

    map.addLayer(newLayer);

    map.zoomOffset = 12;

    map.addControls([
            new OpenLayers.Control.Navigation(),
            new OpenLayers.Control.PanZoomBar()
        ]);

    var position = new OpenLayers.LonLat(lon, lat).transform(
            new OpenLayers.Projection("EPSG:4326"), // transform from WGS 1984
            map.getProjectionObject() // to Spherical Mercator Projection
          );
    map.setCenter(position, zoom);
    
    // add POI layer
    markers = new OpenLayers.Layer.Markers("Markers");
    map.addLayer(markers);
    
    // Create an OLE instance
    editor = new OpenLayers.Editor(map, {
        // Choose which tools shall be available
        activeControls: [
                'DeleteFeature', 'SelectFeature', 'Separator',
                'DragFeature', 'ModifyFeature', 'Separator'
            ],
        // Choose which feature types shall be available
        featureTypes: _featureType
    });

    // Make a toolbar appear so that the user can start to edit
    editor.startEditMode();

    //init parameters
    encodedPolylineConverter_options = {
        'internalProjection': new OpenLayers.Projection("EPSG:900913"),
        'externalProjection': new OpenLayers.Projection("EPSG:4326")
    };

    // Conversions between GeoJSON and OpenLayers objects
    geoJSON = new OpenLayers.Format.GeoJSON(encodedPolylineConverter_options);

    // Conversions between EncodedPolyline and OpenLayers Objects
    encodedPolylineConverter = new OpenLayers.Format.EncodedPolyline(encodedPolylineConverter_options);

    /**
    * Adds or updates a feature. Chosen action depends on the
    * presence of a feature identifier.
    * @param {OpenLayers.Feature.Vector} feature The feature for
    *     which the controller should be returned
    */
    function saveFeature(features) {
        $('input[name="'+geoJsonFieldId+'"]').val(geoJSON.write(features));
        testval = encodedPolylineConverter.write(features)
        //$(geoJsonFieldId).val(encodedPolylineConverter.write(feature));
    }

    // Register event handler so that our code gets notified about new
    // elements on the map
    editor.editLayer.events.register('featureadded', this,
            function (object, element) {
                saveFeature(editor.editLayer.features);
                if (allowOnlyOne) {
                    for (var i = editor.editorPanel.controls.length - 1; i >= 0; i--) {
                        if (allowTracks && editor.editorPanel.controls[i].title == "oleDrawPath") {
                            editor.editorPanel.controls[i].enabled = false;
                            jQuery('div[title="oleDrawPath"]').hide();
                        }
                        else if (allowPoints && editor.editorPanel.controls[i].title == "Draw point") {
                            editor.editorPanel.controls[i].enabled = false;
                            jQuery('div[title="Draw point"]').hide();
                        }
                    }
                }
            }
        );

    // Register event handler so that our code gets notified about
    // elements deleted from the map
            editor.editLayer.events.register('featureremoved', this,
            function (object, element) {
                if (allowOnlyOne) {
                    jQuery('input[name="'+geoJsonFieldId+'"]').val("");
                    if (allowTracks) {
                        jQuery('div[title="oleDrawPath"]').show();
                    }
                    if (allowPoints) {
                        jQuery('div[title="Draw point"]').show();
                    }
                } else {
                    saveFeature(editor.editLayer.features);
                }
            }
        );

    // Register event handler so that our code gets notified about
    // altered elements on the map
    editor.editLayer.events.register('afterfeaturemodified', this,
            function (object, element) {
                // Persist new geometry
                saveFeature(editor.editLayer.features);
                
            }
        );

     map.setOptions({restrictedExtent: maxExtent});

}


// add marker to map    
function addmarker(poi) {
    var dimension_icon = new OpenLayers.Size(32, 32);
    var offset_icon = new OpenLayers.Pixel(-(dimension_icon.w / 2), -dimension_icon.h);
    var adresse_icon = defaultPointerUrl;
    if(poi.icon){
        adresse_icon = poi.icon;
    }
    var icon = new OpenLayers.Icon(adresse_icon, dimension_icon, offset_icon);
    lonlat = new OpenLayers.LonLat(poi.field_poi_localization_lon, poi.field_poi_localization_lat).transform(
            new OpenLayers.Projection("EPSG:4326"), // transform from WGS 1984
            map.getProjectionObject() // to Spherical Mercator Projection
          );
    var mon_marker = new OpenLayers.Marker(lonlat, icon);
    mon_marker.poi_id = poi.poiid;
    markers.addMarker(mon_marker);
    markerstab.push(mon_marker);
}

function addmarkers(poilist) {
    for (x in poilist) {
        addmarker(poilist[x]);
    }
}

function removemarker(poi_id) {
    for (var x in markerstab) {
        if (markerstab[x].poi_id == poi_id) {
            markers.removeMarker(markerstab[x]);
            markerstab.splice(x, 1);
            return;
        }
    }
}

function centertomarker(poi_id) {
    for (var x in markerstab) {
        if (markerstab[x].poi_id == poi_id) {
            map.zoomToExtent(markers.getDataExtent());
            map.setCenter(markerstab[x].lonlat);
            return;
        }
    }
}

function setMapCenter() {
    map.setCenter(new OpenLayers.LonLat(jQuery('#centerlon').val(), jQuery('#centerlat').val()));
}

function setMapCenter(poi) {
    map.setCenter(new OpenLayers.LonLat(poi.lon, poi.lat));
}

function setZoom() {
    map.zoomTo(jQuery('#defaultzoomlevel').val());
}

//Save a feature point into fields
function savePoint(feature){
    var pointToSave = new OpenLayers.Geometry.Point(feature.geometry.getVertices()[0].x, feature.geometry.getVertices()[0].y);
    var myLatLonPoint = pointToSave.transform(map.getProjectionObject(), projWGS84);
    jQuery(lonFieldId).val(pointToSave.x);
    jQuery(latFieldId).val(pointToSave.y);

}

// Initialize map on DOMContentLoaded
function displayMap(initlat, initlon, initzoom, featureType, geoJsonId, poilist, allowOnlyOneItem) {
    // default on FRANCE
    if (initlon == '') initlon = 2.698345147909895;
    if (initlat == '') initlat = 48.40550279913224;
    if (initzoom == '') initzoom = 12;

    //Set the variables in order to limit the editor item numbers
    if (allowOnlyOneItem) {
        allowOnlyOne = allowOnlyOneItem;
        for (var i = 0; i <= featureType.length - 1; i++) {
            if (featureType[i] == 'path') {
                allowTracks = true;
            }
            if (featureType[i] == 'point') {
                allowPoints = true;
            }
        }
    }
    
    initMap(initlon, initlat, initzoom, featureType);

    geoJsonFieldId = geoJsonId;
    
    // display track
    try {
        
        var tmp = jQuery('input[name="'+geoJsonFieldId+'"]').val();
        var features = geoJSON.read(tmp);
        //var features = encodedPolylineConverter.read($(geoJsonFieldId).val());
        editor.editLayer.addFeatures(features);
    } catch (e) {
    }

    // display markers (see addmarker and removemarker)
    if (poilist != null) {
        addmarkers(poilist);
    }
    if (markerstab.length > 0) {
        map.zoomToExtent(markers.getDataExtent());
    }

}

