<?php

/**
 * @file
 * provides forms for track's pois management
 */
global $nodeId;

function mcms_tracks_editor_edit($node) {
 	$nodeId = $node->nid;
  return drupal_get_form('mcms_tracks_editor_edit_form');
}

function mcms_tracks_editor_edit_form($node) {
  global $base_url;
  $nodeId = arg(1);
  $trackItem = node_load($nodeId);
  $geoJSon = mcms_tracks_editor_get_geojson_by_track_id($nodeId);
  $existingPOIs = mcms_tracks_editor_track_pois_list($nodeId);
  $pictoUrl = $base_url. '/'. drupal_get_path('module', 'mcms_tracks_editor') .'/css/img/pointer.png';
   
  foreach ($existingPOIs as $existingPOI) {
    $existingPOI->icon = $pictoUrl;
    if($existingPOI->field_poi_style_image_fid) {
      $existingPOI->icon = file_create_url(file_load($existingPOI->field_poi_style_image_fid)->uri);
    }
  }
  $existingPOIsJSon = drupal_json_encode($existingPOIs);
 
  // Load specified openlayers map
  openlayers_include();
  module_load_include('inc', 'openlayers', 'includes/openlayers.render');
  $editorMap = variable_get("mcms_defaultmap", 'default');
  $map = openlayers_map_load($editorMap);

  $mapData = $map->data;
  //Get all available layers
  $mapData['layers'] = _openlayers_layers_process($mapData['layers'], $mapData);
  $defaultLayerName = $mapData['default_layer'];

  $defaultLayer = $mapData['layers'][$defaultLayerName];

  //MapProvider 
  $jsMapProvider = '"'. $defaultLayer['layer_handler'] .'"';
  //ServerResolutions
  $jsServerResolutions = '[';
  $serverResolutionsCount = count($defaultLayer['serverResolutions']);
  for($i =0; $i < $serverResolutionsCount; $i++)
  {
    $jsServerResolutions = $jsServerResolutions . $defaultLayer['serverResolutions'][$i];
    if($i < ($serverResolutionsCount -1)){
        $jsServerResolutions = $jsServerResolutions .', ';
    }
  }
  $jsServerResolutions = $jsServerResolutions .']';
  
  //map resolution
  $jsResolutions = '[';
  $resolutionsCount = count($defaultLayer['resolutions']);
  for($i =0; $i < $resolutionsCount; $i++)
  {
    $jsResolutions = $jsResolutions . $defaultLayer['resolutions'][$i];
    if($i < ($resolutionsCount -1)){
        $jsResolutions = $jsResolutions .', ';
    }
  }
  $jsResolutions = $jsResolutions .']';
  
  //urls
  $jsUrls = '[';
  $urlDefined = false;
  foreach ($defaultLayer as $key => $value) {
    if($key == 'url')
    {
      $urlDefined = true;
      break;
    }
  }
  if($urlDefined){
    $urlsCount = count($defaultLayer['url']);
    for($i =0; $i < $urlsCount; $i++)
    {
      $jsUrls = $jsUrls .'"'. $defaultLayer['url'][$i] .'"';
      if($i < ($urlsCount -1)){
          $jsUrls = $jsUrls .', ';
      }
    }
  }
  
  $jsUrls = $jsUrls .']';
  
  $jsMaxExtent = '[';
  $restrictExists = false;
  foreach ($mapData['center'] as $key => $value) {
    if($key == 'restrict')
      $restrictExists = true;
  }
  if($restrictExists && $mapData['center']['restrict']['restrictextent'] == 1){
    $extendLimits = array_map('floatval', explode(",", $mapData['center']['restrict']['restrictedExtent']));
    for($i =0; $i < 4; $i++)
    {
      $jsMaxExtent .= $extendLimits[$i];
      if($i < (3)){
          $jsMaxExtent .= ', ';
      }
    }
  }
  $jsMaxExtent .= ']';
  
  //MapCenter and zoom
  $jsZoom = (int)$mapData['center']['initial']['zoom'];
  $centerCoordinates = array_map('floatval', explode(",", $mapData['center']['initial']['centerpoint']));
  $jsCenter = '['.$centerCoordinates[0].', '.$centerCoordinates[1].']';
  
  //end load specified openlayers map
  
	$form = array();
  $form['jsonMarkup'] = array( 
    '#type' => 'markup',
    '#prefix' => '<script language="javascript">
                    var trackPOIs = '. $existingPOIsJSon .';
                    var defaultPointerUrl = "'.$pictoUrl.'";
                    var mcms_mapProvider = '.$jsMapProvider.';
                    var mcms_mapCenter = '.$jsCenter.';
                    var mcms_mapZoom = '.$jsZoom.';
                    var mcms_mapMaxExtent = '.$jsMaxExtent.';
                    var mcms_mapResolutions = '.$jsResolutions.';
                    var mcms_mapServerResolutions = '.$jsServerResolutions.';
                    var mcms_mapProviderUrls = '.$jsUrls.';
                  </script>',
  );
  
  $form['left_container'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="span8" style="margin-left: 0px;">
                        <div id="map" style="width: 700px; height: 500px;">
                        </div>',
  );

  $form['track_id'] = array(
    '#type' => 'hidden',
    '#default_value' => $nodeId,
  );
  
  $form['track_content'] = array(
    '#type' => 'hidden',
    '#default_value' => $geoJSon,
  );
  $form['right_container'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div><div class="span4" style="margin-left: 0px;">
                           <div class="editor-field">',
    );
  
  $form['searchPOI2'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="editor-label"><label>'. t("Search a POI") .'</label>
                        </div>
                        <div class="editor-field"><input id="inputSearch" type="text" class="form-text form-autocomplete" data-provide="typeahead" />',
    );
  
  $form['right_container_middle'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div><div class="editor-label"><label>'. t("Selected POIs") .'</label>
                        </div>
                        <div class="editor-field">',
    );
  $form['selectedPOIs'] = array(
    '#type' => 'hidden',
  );
  
  $pois = '';
  
  foreach ($existingPOIs as $poi){
    $pois .= '<li class="ui-widget-content" value="'.$poi->poiid.'" data-imgsrc="'.$poi->icon.'" data-lon="'.$poi->field_poi_localization_lon.'" data-lat="'.$poi->field_poi_localization_lat.'"><input type="button" id="btnDeletePOI_'.$poi->poiid.'" class="poiDelete btn-mini btn-danger" value="X" onclick="deletePOI(this.id);" /> '.$poi->title.'</li>';
  }
  
  $form['right_container_end'] = array( 
    '#type' => 'markup',
    '#prefix' => '<ul id="pointsList" class="selectable">'.$pois.'</ul></div></div></div></div>',
    );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );
  //Add JS and CSS files
  $form['#attached']['css'] = array(
    drupal_get_path('module', 'mcms_tracks_editor') . '/css/trackform.css',
    drupal_get_path('module', 'mcms_tracks_editor') . '/css/geosilk.css',
    drupal_get_path('module', 'mcms_tracks_editor') . '/css/themes/base/jquery.ui.core.css',
    drupal_get_path('module', 'mcms_tracks_editor') . '/css/themes/base/jquery.ui.theme.css',
    drupal_get_path('module', 'mcms_tracks_editor') . '/css/themes/base/jquery.ui.selectable.css',
    drupal_get_path('module', 'mcms_tracks_editor') . '/css/themes/base/jquery.ui.autocomplete.css',
    drupal_get_path('module', 'mcms_tracks_editor') . '/css/themes/base/jquery.ui.all.css',
  );
  $form['#attached']['js'] = array( 
    drupal_get_path('module','mcms_tracks_editor') . '/js/jquery-1.9.1.min.js',
    drupal_get_path('module','mcms_tracks_editor') . '/js/jquery-ui-1.10.1.js',
    'http://openlayers.org/api/2.13/OpenLayers.js',
    //'/profiles/geolys/libraries/openlayers/OpenLayers.js',
    drupal_get_path('module', 'mcms_tracks_editor') . '/js/ole/loader.js',
    drupal_get_path('module', 'mcms_tracks_editor') . '/js/map.js',
    drupal_get_path('module', 'mcms_tracks_editor') . '/js/pois_management.js',
    drupal_get_path('module', 'mcms_tracks_editor') . '/js/map_init.js',
  );

	return $form;
 }

function mcms_tracks_editor_edit_form_validate($form, &$form_state) {
  // Validation logic.
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_tracks_editor_edit_form_submit($form, &$form_state) {
  $nodeId = $form['track_id']["#value"];
  //Insert/update/delete POIs
  
  mcms_tracks_editor_manage_pois($form['selectedPOIs']["#value"], $nodeId);
  
  //Manage Track
  $trackExists = db_select('mcms_tracks_editor_track_data','t')
          ->fields('t',array('geojson'))
          ->condition('trackid', $nodeId, '=')
          ->execute()
          ->rowCount();
  if($trackExists == 0)
  {
    //Creation
    db_insert('mcms_tracks_editor_track_data')
      ->fields(array(
        'trackid' => $nodeId,
        'geojson' => $form['track_content']["#value"],
        ))
      ->execute();
  } else{
    //update
    db_update('mcms_tracks_editor_track_data')
      ->fields(array(
        'geojson' => $form['track_content']["#value"],
        ))
      ->condition('trackid', $nodeId, '=')
      ->execute();
  }

  // update track timestamp
  $track = node_load($nodeId);
  if($track) {
    node_save($track);
  }


  drupal_set_message(t('The track has been saved'));
}

/**
 * Manage POIs for a specified track
 * @param type $poisString
 * @param type $trackId
 */
function mcms_tracks_editor_manage_pois($poisString, $trackid){
  $existingPOIs = db_select('mcms_tracks_editor_track_pois','t')
          ->fields('t',array('poiid','poiorder'))
          ->condition('trackid', $trackid, '=')
          ->orderBy('poiorder')
          ->execute()
          ->fetchAll();
  $treatedPOIs = array();
  if($poisString != null && $poisString != ""){
    $newPOIs = explode(";#", $poisString);
    //Add or update affected POIs
    if($newPOIs != null && count($newPOIs) > 0) {
      for ($i = 0; $i < count($newPOIs); $i++){
        if(mcms_tracks_editor_item_exists_in_array($existingPOIs, 'poiid', $newPOIs[$i])){
          //update
          db_update('mcms_tracks_editor_track_pois')
            ->fields(array(
              'poiorder' => ($i+1),
              ))
            ->condition(db_and()->condition('trackid', $trackid, '=')->condition('poiid',$newPOIs[$i],'='))
            ->execute();
        }
        else
        {
          //create
          db_insert('mcms_tracks_editor_track_pois')
            ->fields(array(
              'trackid' => $trackid,
              'poiid' => $newPOIs[$i],
              'poiorder' => ($i+1),
              ))
            ->execute();
        }
        //Set poi id as treated
        array_push($treatedPOIs, $newPOIs[$i]);
      }
    }
  }
  //delete all other entries
  $itemsToDelete = array();
  if($treatedPOIs != null && count($treatedPOIs) > 0) {
    $itemsToDelete = mcms_tracks_editor_items_not_existings_in_array($existingPOIs, 'poiid', $treatedPOIs);
  }
  else {
    foreach ($existingPOIs as $poi){
      array_push($itemsToDelete, $poi->poiid);
    }
  }
  
  if($itemsToDelete != null && count($itemsToDelete) > 0) {
    for ($i = 0; $i < count($itemsToDelete); $i++){
      db_delete('mcms_tracks_editor_track_pois')
        ->condition(db_and()->condition('trackid', $trackid, '=')->condition('poiid', $itemsToDelete[$i],'='))
        ->execute();
    }
  }
}

/**
 * Check if an item exists in an array
 * @param type $array
 * @param type $member
 * @param type $value
 * @return boolean
 */
function mcms_tracks_editor_item_exists_in_array($array, $member, $value) {
   foreach($array as $k => $v) {
      if($v->$member == $value)
         return true;
   }
   return false;
}

/**
 * Get all items from SourceArray which don't exists in the compareArray
 * @param type $sourceArray
 * @param type $member
 * @param type $compareArray
 * @return array
 */
function mcms_tracks_editor_items_not_existings_in_array($sourceArray, $member, $compareArray) {
  $returnValues = array();
   foreach($sourceArray as $item) {
      if(!in_array($item->$member, $compareArray))
         array_push($returnValues, $item->$member);
   }
   return $returnValues;
}
  


/**
 * Search in db POIs with title containing the parameter
 */
function mcms_tracks_editor_track_pois_search_auto_complete($string){
  geophp_load();

  $matches = array();
  $query = db_select('node','n')
          ->fields('n',array('title','nid'))
          ->condition(db_and()->condition('title', '%'.$string.'%', 'LIKE')->condition('type','poi','=')->condition('status', 1, '='));
  $query->leftJoin('field_data_field_poi_style', 'ps', 'n.nid = ps.entity_id');
  $query->fields('ps', array('field_poi_style_target_id'));
  $query->leftJoin('field_data_field_poi_style_image', 'psf', 'ps.field_poi_style_target_id = psf.entity_id');
  $query->fields('psf', array('field_poi_style_image_fid'));
  $query->leftJoin('field_data_field_poi_localization', 'p', 'n.nid = p.entity_id');
  $query->fields('p', array('field_poi_localization_lat', 'field_poi_localization_lon'));
  $result = $query->execute()
          ->fetchAll();
  
  foreach ($result as $existingPOI) {
    $existingPOI->icon = '';//http://localhost:20000/geolys/sites/default/files/pointer.png';
    if($existingPOI->field_poi_style_image_fid) {
      $existingPOI->icon = file_create_url(file_load($existingPOI->field_poi_style_image_fid)->uri);
    }
//    $geometry = geoPHP::load($existingPOI->field_poi_localization_wkt);
//    $lon = $geometry->x();
//    $lat = $geometry->y();
//    $existingPOI->field_poi_localization_lat = $lat;
//    $existingPOI->field_poi_localization_lon = $lon;
  }
  
  drupal_json_output($result);
}

function mcms_tracks_editor_track_pois_list($trackid){
  $query = db_select('mcms_tracks_editor_track_pois','t')
          ->fields('t',array('poiid','poiorder'))
          ->condition('trackid', $trackid, '=')
          ->condition('n.status', 1, '=')
          ->orderBy('poiorder');
  $query->leftJoin('node', 'n', 't.poiid = n.nid');
  $query->fields('n', array('title'));
  $query->leftJoin('field_data_field_poi_style', 'ps', 't.poiid = ps.entity_id');
  $query->fields('ps', array('field_poi_style_target_id'));
  $query->leftJoin('field_data_field_poi_style_image', 'psf', 'ps.field_poi_style_target_id = psf.entity_id');
  $query->fields('psf', array('field_poi_style_image_fid'));
  $query->leftJoin('field_data_field_poi_localization', 'p', 't.poiid = p.entity_id');
  $query->fields('p', array('field_poi_localization_lat', 'field_poi_localization_lon'));
  
  $result = $query->execute()
          ->fetchAll();
  return $result;
}

function mcms_tracks_editor_track_pois_list_service($trackid){
  $result = track_pois_list($trackid);
  drupal_json_output($result);
}

/**
 * get the geoJSon data for a specific track node
 * @param int $id
 */
function mcms_tracks_editor_get_geojson_by_track_id($id){
  $result = db_select('mcms_tracks_editor_track_data','t')
          ->fields('t',array('geojson'))
          ->condition('trackid', $id, '=')
          ->execute();
  if($result->rowCount() == 0)
    return '';
  return $result->fetch()->geojson;
}