  <?php

/**
 * @file
 * Manage quiz editor form
 */

/**
 * Menu callback for questions and answers editor
 */
function mcms_quiz_edit(){
  return drupal_get_form('mcms_quiz_edit_form');
}

/**
 * Generate the form allowing user to define the list of questions and answers for a quiz
 */
function mcms_quiz_edit_form(){
  global $base_url;
  
  $quizId = arg(1);
  $jsAddAnswerUrl = $base_url. '/node/' . $quizId . '/questions/add/';
  $existingQuestions = mcms_quiz_get_quiz_questions($quizId, true);
  
  $form = array();
  
  $form['#attributes'] = array('enctype' => 'multipart/form-data');
  
  $form['formJS'] = array( 
    '#type' => 'markup',
    '#prefix' => '<script language="javascript">
                    var mcms_quiz_add_answer_url = "'.$jsAddAnswerUrl.'";
                    var mcms_quiz_correctanswer_label = "'.t("Correct answer").'";
                    var mcms_quiz_answerdelete_label = "'.t("X Delete").'";
                    var mcms_quiz_questiondelete_label = "'.t("- Remove question").'";
                  </script>',
  );
  
  $form['formHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="formHeader" style="margin-left: 0px;">
                        <h2>'.t('Questions associated to the quiz').'</h2>
                        </div>',
  );
  
  $form['questionContainerHeader'] = array(
    '#type' => 'markup',
    '#prefix' => '<div id="questionsContainer">',
  );
  
  $form['deletedQuestions'] = array(
    '#type' => 'hidden',
    '#name' => "deletedQuestions"
  );
  
  $form['deletedAnswers'] = array(
    '#type' => 'hidden',
    '#name' => "deletedAnswers"
  );
  
  $form['deletedThumbnails'] = array(
    '#type' => 'hidden',
    '#name' => "deletedThumbnails"
  );
  
  $form['listQuestions'] = array(
    '#type' => 'hidden',
    '#name' => "listQuestions",
    '#default_value' => drupal_json_encode($existingQuestions),
  );
  
  $form['questionContainerHeader'] = array(
    '#type' => 'markup',
    '#prefix' => '<div id="questionsContainer"><table id="question_table"><thead><tr><th class="dragColumn"></th><th class="field-label quizQuestionColumn" colspan="2"><label>'.t('Questions').'</label></th><th class="deleteColumn"></th><th class="tabledrag-hide" style="display:none;"><label>'.t('Weight').'</label></th></tr></thead><tbody>',
  );
  
  drupal_add_tabledrag('question_table', 'order', 'sibling', 'row-weight');
  
  $form['questionContainerFooter'] = array(
    '#type' => 'markup',
    '#prefix' => '<tbody></table></div>',
  );
  
  $form['addQuestion'] = array(
    '#type' => 'markup',
    '#prefix' => '<div class="footerOptions"><a href="#" onclick="javascript:mcms_quiz_add_question(); return false;">'. t("+ Add a question") .'</a></div>',
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Save'),
  );
  
  $form['formFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div>',
  );
  
  //Add JS and CSS files
  $form['#attached']['css'] = array(
    drupal_get_path('module', 'mcms_quiz') . '/css/quiz.css',
  );
  $form['#attached']['js'] = array(
    drupal_get_path('module', 'mcms_quiz') . '/js/jquery-1.9.1.min.js',
    drupal_get_path('module', 'mcms_quiz') . '/js/jquery-ui-1.10.1.js',
    drupal_get_path('module', 'mcms_quiz') . '/js/tablednd.js',
    drupal_get_path('module', 'mcms_quiz') . '/js/quizbuilder.js',
  );
  
  return $form;
}

/**
 * Implements hook_form_validate
 * @param type $form
 * @param type $form_state
 */
function mcms_quiz_edit_form_validate($form, &$form_state) {
  // Check if at least one question has been entered
  $questionsValue = $form['listQuestions']["#value"];
  if(!isset($questionsValue) || $questionsValue == "")
    form_set_error('List of questions', t('Please add at least one question'));

  
  //for each question, verify the mandatory fields
  $questions = drupal_json_decode($questionsValue);
  
  foreach ($questions as $question){
    $hasValid = 0;
    //dpm($question);
    if(count($question['answers']) < 2)
      form_set_error('answers count', "A question must have at least two answers");
    foreach($question['answers'] as $answer){
      if(!isset($answer['text']) || $answer['text'] == "")
        form_set_error ('answer text', t('Each answer must have a text'));
      if($answer['isValid'])
        $hasValid++;
    }
    if($hasValid == 0)
      form_set_error ('questionsCorrectAnswer', t("A question must have at least one correct answer"));
  }
  //form_set_error('debug', "stop here");
  //file upload
  foreach ($_FILES as $key => $value) {
    
    $file = mcms_quiz_file_save_upload($key, array(
      'file_validate_is_image' => array(), // Validates file is really an image.
      'file_validate_extensions' => array('png gif jpg jpeg'), // Validate extensions.
    ));
    // If the file passed validation:
    
    if ($file) {
      // Move the file, into the Drupal file system
      if ($file = file_move($file, 'public://')) {
        // Save the file for use in the submit handler.
        $form_state['storage'][$key] = $file;
      }
      else {
        form_set_error('file', t('Failed to write the uploaded file to the site\'s file folder.'));
      }
    }
    //else {
      //form_set_error('file', t('No file was uploaded.'));
    //}
  }
  
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_quiz_edit_form_submit($form, &$form_state) {
  $quizId = arg(1);
  //First manage deleted question
  $deletedQuestions = $form['deletedQuestions']["#value"];
  if(isset($deletedQuestions) && $deletedQuestions != ""){
    $questionsToDelete = explode(";#", $deletedQuestions);
    foreach($questionsToDelete as $questionId){
      if($questionId != -1)
        mcms_quiz_delete_question($questionId);
    }
  }
  
  //Then manage deleted anwers
  $deletedAnswers = $form['deletedAnswers']["#value"];
  if(isset($deletedAnswers) && $deletedAnswers != ""){
    $answersToDelete = explode(";#", $deletedAnswers);
    $answersToDeleteFiltered = array();
    foreach ($answersToDelete as $aid) {
      if($aid != -1)
        array_push ($answersToDeleteFiltered, $aid);
    }
    if(count($answersToDeleteFiltered) > 0){
      db_delete('mcms_quiz_answers')
          ->condition("aid", $answersToDeleteFiltered, "IN")
          ->execute();
    }
  }
  
  //and delete pictures
  $deletedThumbnails = $form['deletedThumbnails']['#value'];
  if(isset($deletedThumbnails) && $deletedThumbnails != ""){
    $filesToDelete = explode(";#", $deletedThumbnails);
    $files = file_load_multiple($filesToDelete);
    foreach ($files as $file) {
      file_delete($file);
    }
  }
  
  //Finally, add or update existing questions
  $questionsValue = $form['listQuestions']["#value"];
  //for each question, verify the mandatory fields
  $questions = drupal_json_decode($questionsValue);
  for($i=0; $i < count($questions); $i++){
    $question = $questions[$i];
    $isNew = ($question["qid"] == -1);
    $fid = null;
    $key = mcms_quiz_get_key($_FILES, $i);
    //dpm($question);
    $existingFid = $question["fid"];
    if(isset($existingFid) && $existingFid != ""){
      $fid = $existingFid;
    }
    else if(isset($form_state['storage'][$key])) {
      $fid = $form_state['storage'][$key]->fid;
    }
    
    if($isNew){
      //insert new question
      db_insert('mcms_quiz_questions')
            ->fields(array(
              'qid' => $quizId,
              'question' => $question["title"],
              'description' => $question["description"],
              'qorder' => ($i+1),
              //TODO:
              'fid' => $fid,
              ))
            ->execute();
        $questionId = db_select("mcms_quiz_questions", "q")
                        ->fields("q", array("questionid"))
                        ->condition(db_and()->condition("qid", $quizId, "=")->condition("question", $question["title"]))
                        ->execute()
                        ->fetchColumn();
        //insert related answers
        for($j = 0; $j < count($question["answers"]); $j++){
          $answer = $question["answers"][$j];
          db_insert('mcms_quiz_answers')
            ->fields(array(
              'questionid' => $questionId,
              'answer' => $answer["text"],
              'iscorrect' => $answer["isValid"] ? 1 : 0,
              ))
            ->execute();
        }
    } else {
      //update existing question
      db_update('mcms_quiz_questions')
            ->fields(array(
              'question' => $question["title"],
              'description' => $question["description"],
              'qorder' => ($i+1),
              'fid' => $fid
              ))
            ->condition('questionid',$question["qid"],'=')
            ->execute();
        foreach ($question["answers"] as $answer) {
          if($answer["aid"] == -1){
            //add new answer
            db_insert('mcms_quiz_answers')
            ->fields(array(
              'questionid' => $question["qid"],
              'answer' => $answer["text"],
              'iscorrect' => $answer["isValid"] ? 1 : 0,
              ))
            ->execute();
          } else {
            //update existing answer
            db_update('mcms_quiz_answers')
            ->fields(array(
              'answer' => $answer["text"],
              'iscorrect' => $answer["isValid"] ? 1 : 0,
              ))
            ->condition('aid',$answer["aid"],'=')
            ->execute();
          }
        }
    }
  }
  drupal_set_message(t("The quiz has been updated"));
}

/**
 * Return a new question form
 * @param type $node
 */
function mcms_quiz_edit_add_question_ajax_callback($node, $id) {

  $form = array();

  $form['formSplitTop'] = array( 
    '#type' => 'markup',
    '#prefix' => '<label>;#</label>',
  );
  
  $form["question_title_".$id] = array(
    "#type" => 'textfield',
    "#title" => t('Question'),
    '#required' => TRUE,
    "#name" => "question_title_".$id,
  );
  $form["question_description_".$id] = array(
    "#type" => 'textarea',
    "#title" => t('Description'),
    '#required' => TRUE,
    "#name" => "question_description_".$id,
  );
  $form['question_image_'.$id] = array(
    '#type' => 'file',
    '#name' => 'question_image_'.$id,
    '#title' => t('Thumbnail'),
    '#description' => t("Image should be less than 600 pixels wide and in JPG format."),
  ); 
  
  $form['question_image_fid_'.$id] = array(
    '#type' => 'hidden',
    '#name' => 'question_image_fid_'.$id,
  );
  $form['question_image_changed_'.$id] = array(
    '#type' => 'hidden',
    '#name' => 'question_image_changed_'.$id,
  );
  $form['question_image_display_'.$id] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="imageDisplay hidden"><div><img src="" class="thumbnailImage"/></div><div><a href="#" onclick="javascript:mcms_quiz_remove_picture(this); return false;">'.t("X Remove picture").'</a></div></div>',
  ); 
   
  $form['question_answers_start_'.$id] = array( 
    '#type' => 'markup',
    '#prefix' => '<div id="answersContainer_'.$id.'" class="answersContainer"><label>'.t('Answers').' <span title="'.t("This field is required.").'" class="form-required">*</span></label><div class="answersValues">',
  );
  
  $form['question_answers_default_'.$id] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="possibleAnswer" data-answerindex="1" data-answerid="-1"><input type="text" class="form-text answer-text required" size="60" name="question_'.$id.'_answer_1" /><label class="validAnswer"><input type="checkbox" name="question_'.$id.'_answer_1_valid"/>'.t("Correct answer").'</label><a href="#" onclick="javascript:mcms_quiz_removeAnswer(this); return false;">'.t("X Delete").'</a></div>
                  <div class="possibleAnswer" data-answerindex="2" data-answerid="-1"><input type="text" class="form-text answer-text required" size="60" name="question_'.$id.'_answer_2" /><label class="validAnswer"><input type="checkbox" name="question_'.$id.'_answer_2_valid"/>'.t("Correct answer").'</label><a href="#" onclick="javascript:mcms_quiz_removeAnswer(this); return false;">'.t("X Delete").'</a></div>',
  );
  
  $form['question_answers_end_'.$id] = array( 
    '#type' => 'markup',
    '#prefix' => '</div><a href="#" onclick="javascript:mcms_quiz_addAnswer(\'#answersContainer_'.$id.'\'); return false;">'. t("+ Add an answer") .'</a></div>',
  );
  
  $form['formSplitBottom'] = array( 
    '#type' => 'markup',
    '#prefix' => '<label>;#</label>',
  );
  
  return $form;
}