<?php

/**
 * @file
 * provides forms for track's pois management
 */
global $nodeId;

function mcms_mobile_codes_edit($node) {
  //global $nodeId;
  $nodeId = $node->nid;
  //return theme('geolys_track_pois');
  return drupal_get_form('mcms_mobile_codes_edit_form');
}

function mcms_mobile_codes_edit_form($node) {
  global $base_url;
  $nodeId = arg(1);
  $suffix = drupal_lookup_path('alias','node/'.$nodeId) === FALSE ? 'node/'.$nodeId : drupal_lookup_path('alias','node/'.$nodeId);
  $prefix = mcms_mobile_codes_getPrefix();
  if(count($prefix) > 0){
  	$prefix = $prefix[0];
  	$prefix = $prefix->prefix;
  }else{
  	$prefix = '';
  }
  
  $url = $prefix.$suffix;
  $qrcodeurl = 'https://chart.googleapis.com/chart?chs=widthxheight&cht=qr&chld=H|0&chl='.$url;

  $form = array();//affichage
  
  $form['top_container'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div style="margin-left: 0px;">
	 				<img id="imgQr" src="'.str_replace('height','250',str_replace('width','250',$qrcodeurl)).'" alt=""/>',
	'#suffix' => '</div>'
  );
  
  $form['bottom_container'] = array(
  	'#type' => 'markup',
	'#prefix' => '<div style="margin-left:0px;">',
	'#suffix' => '</div>'
  );
  
  $form['bottom_container']['width'] = array(
  	'#type' => 'textfield',
	'#attributes' => array('name' => 'txtWidth', 'id' => 'txtWidth'), 
	'#title' => t('QR Code width')
  );
  
  $form['bottom_container']['height'] = array(
  	'#type' => 'textfield',
	'#attributes' => array('name' => 'txtHeight', 'id' => 'txtHeight'), 
	'#title' => t('QR Code height')
  );
  
  $form['bottom_container']['valide'] = array(
  	'#type' => 'button',
	'#executes_submit_callback' => FALSE,
	'#attributes' => array('name' => 'cmdValide', 'id' => 'cmdValide'), 
	'#value' => t('Create')
  );
  
  $form['top_container']['track_id'] = array(
    '#type' => 'hidden',
    '#default_value' => $nodeId,
  );
  $form['left_container']['url'] = array(
    '#type' => 'hidden',
	'#attributes' => array('name' => 'txtQrCodeUrl', 'id' => 'txtQrCodeUrl'),
    '#default_value' => $qrcodeurl,
  );
  
  $form['#attached']['js'] = array(
    drupal_get_path('module','mcms_mobile_codes') . '/js/jquery-1.9.1.min.js',
    drupal_get_path('module','mcms_mobile_codes') . '/js/mcms_mobile_codes_init_qr.js'
  );
  
  return $form;
 }

function mcms_mobile_codes_edit_form_validate($form, &$form_state) {
  // Validation logic.
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_mobile_codes_edit_form_submit($form, &$form_state) {
  $nodeId = $form['track_id']["#value"];
}


