<?php
/**
 * Menu callback for mobile_codes management
 * @return html form array
 */
function mcms_mobile_codes_config_edit()
{
  return drupal_get_form('mcms_mobile_codes_config_edit_form');
}

/**
 * Define the html form array for content types management
 */
function mcms_mobile_codes_config_edit_form(){
  $form = array();
  
  $form['formHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="formHeader" style="margin-left: 0px;">
                        <h2>'.t('Define all the content types that support QR Codes').'</h2>
                        </div>',
  );
  
  $form['tableHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<table class="tableheader-processed" id="inAppPurchaseByContentType">
                    <thead>
                      <tr>
                        <th>'. t('Content type').'</th>
                        <th>'. t('QR Codes enabled').'</th>
                      </tr>
                    </thead>
                    <tbody>',
  );
  
  $cts = mcms_mobile_codes_get_content_types();
  $i = 0;
  foreach ($cts as $ct) {
    $rowStyle = $i % 2 ==0 ? "odd" : "even";
    $form['row-start-'.$ct->contenttype] = array( 
    '#type' => 'markup',
    '#prefix' => '<tr class="'.$rowStyle.'">
                    <td>'.t($ct->contenttype).'</td>
                    <td>',
    );
    
    $form[$ct->contenttype] = array( 
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => 0,
    );
    if($ct->enabled == 1)
      $form[$ct->contenttype]['#attributes'] = array('checked' => 'checked');
    
    $form['row-end-'.$ct->contenttype] = array( 
    '#type' => 'markup',
    '#prefix' => '</td>
                 </tr>',
    );
    $i++;
  }
  
  
  $form['tableFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</tbody>
                </table>',
  );
  $prefix = mcms_mobile_codes_getPrefix();
  if(count($prefix) > 0){
  	$prefix = $prefix[0];
    $prefix = $prefix->prefix;
  }else{
  	$prefix = '';
  }
  
  
  $form['prefix_url'] = array(
    '#type' => 'textfield',
	'#default_value' => $prefix,
	'#title' => t('Prefix of url (In example => http://)'),
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );
  
  $form['formFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div>',
  );
  
  return $form;
}


/**
 * Implements hook_form_validate
 * @param type $form
 * @param type $form_state
 */
function mcms_mobile_codes_config_edit_form_validate($form, &$form_state) {
  // Validation logic.
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_mobile_codes_config_edit_form_submit($form, &$form_state) {
  $nodeTypes = node_type_get_types();
  $formValues = array();
  //Get all values from the form
  foreach ($nodeTypes as $key => $value) {
    $newVal = new stdClass();
    $newVal->contenttype = $key;
    $newVal->enabled = $form[$key]['#value'];
    array_push($formValues, $newVal);
  }
  
  //Retrieve existing configurations
  $alreadyConfiguredCT = mcms_mobile_codes_get_all_content_types();
  $itemsToAdd = array();
  $itemsToUpdate = array();
  if(count($alreadyConfiguredCT) != 0) {
    foreach ($formValues as $formValue) {
      if(!mcms_mobile_codes_item_exists_in_array($alreadyConfiguredCT, 'contenttype', $formValue->contenttype)){
        array_push($itemsToAdd, $formValue);
      } else if(mcms_mobile_codes_get_existing_item_in_array($alreadyConfiguredCT, 'contenttype', $formValue->contenttype)->enabled != $formValue->enabled) {
        array_push($itemsToUpdate, $formValue); 
      }
    }
  } else {
    foreach ($formValues as $formValue) {
      array_push($itemsToAdd, $formValue);
    }
  }
  
  $tableEnabled = 'mcms_mobile_codes_contenttypes';
  //Add all new CTs
  foreach ($itemsToAdd as $item) {
    db_insert($tableEnabled)
        ->fields(array('contenttype' => $item->contenttype, 
                       'enabled' => $item->enabled))
        ->execute();
  }
  
  //Update all items that need it
  foreach ($itemsToUpdate as $item) {
    db_update($tableEnabled)
        ->fields(array('enabled' => $item->enabled))
        ->condition('contenttype', $item->contenttype, '=')
        ->execute();
  }
  
  //delete all items that doesn't exists anymore
  $ctNames = array();
  foreach ($nodeTypes as $key => $value) {
    array_push($ctNames, $key);
  }
  $itemsToDelete = mcms_likes_get_items_not_existings_in_array($alreadyConfiguredCT, 'contenttype', $ctNames);
  for ($i = 0; $i < count($itemsToDelete); $i++){
    db_delete($tableEnabled)
      ->condition('contenttype', $itemsToDelete[$i], '=')
      ->execute();
  }
  
  $tablePrefix = 'mcms_mobile_codes_prefix';
  //changment du prefix
  $prefix = $form['prefix_url']['#value'];
  db_truncate($tablePrefix)->execute();
  db_insert($tablePrefix)->fields(array('prefix'=> $prefix))->execute();
  
  drupal_set_message(t('QR Codes configuration has been updated.'));
}

/**
 * Build an array containing all availables CT with a boolean indicating if QR Codes has been enabled
 */
function mcms_mobile_codes_get_content_types(){
  //all availables Content types
  $nodeTypes = node_type_get_types();
  $alreadyConfiguredCT = mcms_mobile_codes_get_all_content_types();
  $itemsToAdd = array();
  foreach ($nodeTypes as $key => $value) {
    if(!mcms_mobile_codes_item_exists_in_array($alreadyConfiguredCT, 'contenttype', $key)){
      $newCT = new stdClass();
      $newCT->contenttype = $key;
      $newCT->enabled = 0;
      array_push($alreadyConfiguredCT, $newCT);
    }
  }
  return $alreadyConfiguredCT;
}

/**
 * Get all configured content types for QR Codes
 * @return type
 */
function mcms_mobile_codes_get_all_content_types(){
  return db_select('mcms_mobile_codes_contenttypes', 'ct')
          ->fields('ct', array('contenttype', 'enabled'))
          ->execute()
          ->fetchAll();
}
?>