<?php

/**
 * @file define forms and callbacks for in-app purchase configuration
 * 
 */

/**
 * Menu callback for in-app purchase management
 * @return html form array
 */
function mcms_inapppurchase_config_edit()
{
  return drupal_get_form('mcms_inapppurchase_config_edit_form');
}

/**
 * Define the html form array for content types management
 */
function mcms_inapppurchase_config_edit_form(){
  $form = array();
  
  $form['formHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<div class="formContainer"><div class="formHeader" style="margin-left: 0px;">
                        <h2>'.t('Define all the content types that can be sold').'</h2>
                        </div>',
  );
  
  $form['tableHeader'] = array( 
    '#type' => 'markup',
    '#prefix' => '<table class="tableheader-processed" id="inAppPurchaseByContentType">
                    <thead>
                      <tr>
                        <th>'. t('Content type').'</th>
                        <th>'. t('Pricing enabled').'</th>
                      </tr>
                    </thead>
                    <tbody>',
  );
  
  $cts = mcms_inapppurchase_get_content_types_for_purchase();
  $i = 0;
  foreach ($cts as $ct) {
    $rowStyle = $i % 2 ==0 ? "odd" : "even";
    $form['row-start-'.$ct->contenttype] = array( 
    '#type' => 'markup',
    '#prefix' => '<tr class="'.$rowStyle.'">
                    <td>'.t($ct->contenttype).'</td>
                    <td>',
    );
    
    $form[$ct->contenttype] = array( 
      '#type' => 'checkbox',
      '#return_value' => 1,
      '#default_value' => 0,
    );
    if($ct->enabled == 1)
      $form[$ct->contenttype]['#attributes'] = array('checked' => 'checked');
    
    $form['row-end-'.$ct->contenttype] = array( 
    '#type' => 'markup',
    '#prefix' => '</td>
                 </tr>',
    );
    $i++;
  }
  
  
  $form['tableFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</tbody>
                </table>',
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Submit'),
  );
  
  $form['formFooter'] = array( 
    '#type' => 'markup',
    '#prefix' => '</div>',
  );
  
  return $form;
}

/**
 * Implements hook_form_validate
 * @param type $form
 * @param type $form_state
 */
function mcms_inapppurchase_config_edit_form_validate($form, &$form_state) {
  // Validation logic.
}

/**
 * Implements hook_form_submit
 * @global type $nodeId
 * @param type $form
 * @param type $form_state
 */
function mcms_inapppurchase_config_edit_form_submit($form, &$form_state) {
  $nodeTypes = node_type_get_types();
  $formValues = array();
  //Get all values from the form
  foreach ($nodeTypes as $key => $value) {
    $newVal = new stdClass();
    $newVal->contenttype = $key;
    $newVal->enabled = $form[$key]['#value'];
    array_push($formValues, $newVal);
  }
  
  //Retrieve existing configurations
  $alreadyConfiguredCT = mcms_inapppurchase_get_all_content_types();
  $itemsToAdd = array();
  $itemsToUpdate = array();
  if(count($alreadyConfiguredCT) != 0) {
    foreach ($formValues as $formValue) {
      if(!mcms_inapppurchase_item_exists_in_array($alreadyConfiguredCT, 'contenttype', $formValue->contenttype)){
        array_push($itemsToAdd, $formValue);
      } else if(mcms_inapppurchase_get_existing_item_in_array($alreadyConfiguredCT, 'contenttype', $formValue->contenttype)->enabled != $formValue->enabled) {
        array_push($itemsToUpdate, $formValue); 
      }
    }
  } else {
    foreach ($formValues as $formValue) {
      array_push($itemsToAdd, $formValue);
    }
  }
  
  //Add all new CTs
  foreach ($itemsToAdd as $item) {
    db_insert('mcms_inapppurchase_contenttypes_inapppurchase')
        ->fields(array('contenttype' => $item->contenttype, 
                       'enabled' => $item->enabled))
        ->execute();
  }
  
  //Update all items that need it
  foreach ($itemsToUpdate as $item) {
    db_update('mcms_inapppurchase_contenttypes_inapppurchase')
        ->fields(array('enabled' => $item->enabled))
        ->condition('contenttype', $item->contenttype, '=')
        ->execute();
  }
  
  //delete all items that doesn't exists anymore
  $ctNames = array();
  foreach ($nodeTypes as $key => $value) {
    array_push($ctNames, $key);
  }
  $itemsToDelete = mcms_inapppurchase_get_items_not_existings_in_array($alreadyConfiguredCT, 'contenttype', $ctNames);
  for ($i = 0; $i < count($itemsToDelete); $i++){
    db_delete('mcms_inapppurchase_contenttypes_inapppurchase')
      ->condition('contenttype', $itemsToDelete[$i], '=')
      ->execute();
  }
  
  drupal_set_message(t('In-app purchase configuration has been updated.'));
}

/**
 * Build an array containing all availables CT with a boolean indicating if in app purchase has been enabled
 */
function mcms_inapppurchase_get_content_types_for_purchase(){
  //all availables Content types
  $nodeTypes = node_type_get_types();
  $alreadyConfiguredCT = mcms_inapppurchase_get_all_content_types();
  $itemsToAdd = array();
  foreach ($nodeTypes as $key => $value) {
    if(!mcms_inapppurchase_item_exists_in_array($alreadyConfiguredCT, 'contenttype', $key)){
      $newCT = new stdClass();
      $newCT->contenttype = $key;
      $newCT->enabled = 0;
      array_push($alreadyConfiguredCT, $newCT);
    }
  }
  return $alreadyConfiguredCT;
}

/**
 * Get all configured content types for in-app purchase
 * @return type
 */
function mcms_inapppurchase_get_all_content_types(){
  return db_select('mcms_inapppurchase_contenttypes_inapppurchase', 'ct')
          ->fields('ct', array('contenttype', 'enabled'))
          ->execute()
          ->fetchAll();
}

