<?php

/**
 * Get all books API callback
 * @param type $lang
 * @param type $timestamp
 * @param type $parentid
 *
 * @todo  Fusionner les répétitions (en 3 exemplaires) initialement implémentées dans cette fonctinon
 */
function mcms_contents_services_contents_index($lang = "", $timestamp = NULL, $parentid = NULL){

  // Liste des champs à afficher
  $displayIndexFields = array(
    'nid',
    'changed',
    'title',
    // 'title_field:value:multilangue',
    'parentid',
    'index',
    'bid',
    'field_book_listimage::image,multilangue',
  );

  $results = array();

  // Valeur qui contiendra le timestamp le plus élevé des nodes retournés
  $max_timestamp = 0;

  // Get all books and pages (if parentid non renseigné)
  if(is_null($parentid)){

    // Construction de la requête au fur et à mesure
    $getAllQuery = db_select("book", "b")                           // Request book table
    ->fields('b', array('mlid', 'nid', 'bid'))
    ->fields('ml', array("depth", "plid"))
    ->condition("status", 1, "=");                                  // Only published nodes
    $getAllQuery->leftJoin("menu_links", "ml", "ml.mlid = b.mlid"); // Join menu_links table
    $getAllQuery->leftJoin("node", "n", "n.nid = b.nid");           // Join node table

    // Add filter on timestamp if exists
    if (isset($timestamp)) {
      $getAllQuery->condition('n.changed',$timestamp,'>');
    }

    // // Add language filter if exists
    // if(isset($lang)) {
    //   $getAllQuery->condition('n.language',$lang);//on rajoute une condition sur la langue
    // }

    // Order by
    $getAllQuery->orderBy("b.bid", "ASC")
    ->orderBy("ml.plid", "ASC")
    ->orderBy("ml.weight", "ASC")
    ->orderBy("n.title", "ASC");

    // Execute query
    $orderedTmpResults = $getAllQuery->execute()->fetchAll();

    // Liste nids
    $nids = array();
    foreach ($orderedTmpResults as $tmpRes) {
      array_push($nids, $tmpRes->nid);
    }

    // mlid   => menu_link id
    // nid    => node id
    // bid    => book id = node id
    // depth  => menu_link
    // plid   => menu_link parent id

    // Chargement des nodes
    $nodes = node_load_multiple($nids);

    // Si une langue est spécifiée retirer les éléments qui ne sont pas disponible dans cette langue
    if (!is_null($lang) && ($lang != "")) {
      foreach($nodes as $item){

        // Récupérer les langues activées pour ce node
        $activated_languages = _get_node_activated_languages($item);
        // Exclure les nodes dont la langue demandée n'est pas activée
        if (!in_array($lang, $activated_languages)) {
          unset($nodes[$item->nid]);
        }
      }
    }

    $lastParentId = 0;  //nid du parent (0 si root)
    $index = 1;

    foreach($nodes as $tmpResult){

      // Get parent id et index
      if($tmpResult->book['plid'] == 0) {
        $lastParentId = 0;
        $index = 1;
      }
      else{

        // Regarde si le parent fait parti des éléments récupérés
        $pid = isset(_mcms_contents_services_get_existing_item_in_array($orderedTmpResults, "mlid", $tmpResult->book['plid'])->nid) ? _mcms_contents_services_get_existing_item_in_array($orderedTmpResults, "mlid", $tmpResult->book['plid'])->nid : NULL;

        // Sinon faire une requête en BDD (pour récupérer nid du parent)
        if(!isset($pid)){
         $pid = db_select("book", "b")
         ->fields('b', array('nid'))
         ->condition('mlid', $tmpResult->book['plid'], '=')
         ->execute()
         ->fetchColumn();
        }

        // Affecte parent id
        if($lastParentId != $pid){
          $lastParentId = $pid;
          $index = 1;
        }
      }

      // Récupère node chargé
      // $node = _mcms_contents_services_get_existing_item_in_array($nodes, "nid", $tmpResult->nid);
      $node = $tmpResult;
      $node->parentid = $lastParentId;
      $node->bid = $tmpResult->book['plid'];
      $node->index = $index++;
      $range = array();

      // Filtrage des champs
      mcms_services_parcours_recursive($node, $displayIndexFields, $lang, $range);

      // Traitement particulier pour garder une "retro compatibilité" :
      // si on demande une langue, et si un title_field existe, écraser la title par la valeur du title_field de la langue demandée
      if (!is_null($lang) && ($lang != "") && isset($node->title_field[$lang])) {
        if (isset($range['title'])) {
          $range['title'] = $node->title_field[$lang][0]['value'];
        }
      }

      // Path alias
      $path_alias = drupal_lookup_path('alias','node/'.$range['nid']);
      $range['path_alias'] = $path_alias === false ? 'node/' . $range['nid'] : $path_alias;

      // Ajout du node à la liste des nodes
      $results['data'][] = $range;

      // Regarde si son timestamp est le plus élevé
      if ($node->changed > $max_timestamp) {
        $max_timestamp = $node->changed;
      }
    }
  }

  // Get all ROOT nodes
  else if($parentid == 0) {

    $getRootsQuery = db_select("book", "b")
    ->fields('b', array('mlid', 'nid', 'bid'))
    ->fields('ml', array("depth", "plid"));
    $getRootsQuery->leftJoin("menu_links", "ml", "ml.mlid = b.mlid");
    $getRootsQuery->leftJoin("node", "n", "n.nid = b.nid");
    $getRootsQuery->condition("status", 1, "=");
    $getRootsQuery->condition("ml.plid", 0, "="); //Only root nodes

    //Add filter on timestamp if exists
    if(isset($timestamp) ) {
      $getRootsQuery->condition('n.changed',$timestamp,'>');
    }

    // //Add language filter if exists
    // if(isset($lang)) {
    //   $getRootsQuery->condition('n.language',$lang);//on rajoute une condition sur la langue
    // }

    //order by
    $getRootsQuery->orderBy("b.bid", "ASC")
    ->orderBy("ml.plid", "ASC")
    ->orderBy("ml.weight", "ASC")
    ->orderBy("n.title", "ASC");

    $orderedTmpResults = $getRootsQuery->execute()->fetchAll();

    // mlid   => menu_link id
    // nid    => node id
    // bid    => book id = node id
    // depth  => menu_link
    // plid   => menu_link

    if (isset($orderedTmpResults)) {

      // Liste nids
      $nids = array();
      foreach ($orderedTmpResults as $tmpResult) {
        array_push($nids, $tmpResult->nid);
      }

      // Chargement des nodes
      $nodes = node_load_multiple($nids);

      // Si une langue est spécifiée retirer les éléments qui ne sont pas disponible dans cette langue
      if (!is_null($lang) && ($lang != "")) {
        foreach($nodes as $item){

          // Récupérer les langues activées pour ce node
          $activated_languages = _get_node_activated_languages($item);
          // Exclure les nodes dont la langue demandée n'est pas activée
          if (!in_array($lang, $activated_languages)) {
            unset($nodes[$item->nid]);
          }
        }
      }

      $results['data'] = array();
      $index = 1;

      // Pour chaque node trouvé
      foreach($nodes as $node){

        $node->index = $index++;
        $node->parentid = 0;
        $range = array();

        // Filtrage des champs
        mcms_services_parcours_recursive($node, $displayIndexFields, $lang, $range);

        // Traitement particulier pour garder une "retro compatibilité" :
        // si on demande une langue, et si un title_field existe, écraser la title par la valeur du title_field de la langue demandée
        if (!is_null($lang) && ($lang != "") && isset($node->title_field[$lang])) {
          if (isset($range['title'])) {
            $range['title'] = $node->title_field[$lang][0]['value'];
          }
        }

        // Ajout du path alias
        $path_alias = drupal_lookup_path('alias','node/'.$range['nid']);
        $range['path_alias'] = $path_alias === false ? 'node/' . $range['nid'] : $path_alias;

        // Ajout le node à la liste des nodes
        $results['data'][] = $range;

        // Regarde si son timestamp est le plus élevé
        if ($node->changed > $max_timestamp) {
          $max_timestamp = $node->changed;
        }
      }
    }
  }

  // Get all children nodes of prentid node
  else {

    //Get the menu link id of the parent node
    $mlid = db_select("book", "b")
    ->fields("b", array("mlid"))
    ->condition("nid", $parentid, "=")
    ->execute()
    ->fetchField();

    if(!isset($mlid)) {
      $results["data"] = NULL;
    }
    else {

      //Get only the subpages
      $getSubNodesQuery = db_select("book", "b")
      ->fields('b', array('mlid', 'nid', 'bid'))
      ->fields('ml', array("depth", "plid"));
      $getSubNodesQuery->leftJoin("menu_links", "ml", "ml.mlid = b.mlid");
      $getSubNodesQuery->leftJoin("node", "n", "n.nid = b.nid");
      $getSubNodesQuery->condition("status", 1, "=");
      $getSubNodesQuery->condition("ml.plid", $mlid, "="); //Only sub nodes

      //Add filter on timestamp if exists
      if(isset($timestamp)) {
        $getSubNodesQuery->condition('n.changed',$timestamp,'>');
      }

      // //Add language filter if exists
      // if(isset($lang)) {
      //   $getSubNodesQuery->condition('n.language',$lang);//on rajoute une condition sur la langue
      // }

      //order by
      $getSubNodesQuery->orderBy("b.bid", "ASC")
      ->orderBy("ml.plid", "ASC")
      ->orderBy("ml.weight", "ASC")
      ->orderBy("n.title", "ASC");
      $orderedTmpResults = $getSubNodesQuery->execute()->fetchAll();

      if (isset($orderedTmpResults)) {

        // Liste nids
        $nids = array();
        foreach ($orderedTmpResults as $tmpResult) {
          array_push($nids, $tmpResult->nid);
        }

        // Chargement des nodes
        $nodes = node_load_multiple($nids);

        // Si une langue est spécifiée retirer les éléments qui ne sont pas disponible dans cette langue
        if (!is_null($lang) && ($lang != "")) {
          foreach($nodes as $item){

            // Récupérer les langues activées pour ce node
            $activated_languages = _get_node_activated_languages($item);
            // Exclure les nodes dont la langue demandée n'est pas activée
            if (!in_array($lang, $activated_languages)) {
              unset($nodes[$item->nid]);
            }
          }
        }

        $results['data'] = array();
        $index = 1;

        foreach($nodes as $node){

          $node->index = $index++;
          $node->parentid = $parentid;
          $range = array();

          // Filtrage des champs
          mcms_services_parcours_recursive($node, $displayIndexFields, $lang, $range);

          // Traitement particulier pour garder une "retro compatibilité" :
          // si on demande une langue, et si un title_field existe, écraser la title par la valeur du title_field de la langue demandée
          if (!is_null($lang) && ($lang != "") && isset($node->title_field[$lang])) {
            if (isset($range['title'])) {
              $range['title'] = $node->title_field[$lang][0]['value'];
            }
          }

          // Path Alias
          $path_alias = drupal_lookup_path('alias','node/'.$range['nid']);
          $range['path_alias'] = $path_alias === false ? 'node/' . $range['nid'] : $path_alias;

          // Ajout du node à la liste des nodes
          $results['data'][] = $range;

          // Regarde si son timestamp est le plus élevé
          if ($node->changed > $max_timestamp) {
            $max_timestamp = $node->changed;
          }
        }
      }
    }
  }

  // On vérifie si des nodes sont trouvés
  if(!isset($results['data']) || count($results['data']) < 1){
  	return mcms_services_no_found($timestamp, 'book', 'mcms_purge_node_entries');
  }

  // Ajout du count
  $results['count'] = count($results['data']);

  // Ajout du timestamp
  $results['ts'] = $max_timestamp;

  // Purger
  $results['deleted'] = mcms_purge_node_entries($timestamp, 'book');

  // Retourner le résultat
  return $results;
}

// /**
//  * Get a specific book node API callback
//  * @param type $nid
//  * @param type $lang
//  */
// function mcms_contents_services_contents_retrieve($nid, $lang = "") {
//   return array('test_retrieve');
// }
